#!/bin/bash

#=========================================================================================
# Model & Environment Configuration
#=========================================================================================
NLAYERS=48
NHIDDEN=3072
NATT=48
MAXSEQLEN=1024
MASTER_PORT=$(shuf -n 1 -i 10000-65535)
MPSIZE=1

#=========================================================================================
# Sampling & Generation Arguments
#=========================================================================================
TEMP=1.05
TOPK=12
# Set the path to your reference image. This image will be used as the starting frame.
REFERENCE_IMAGE_PATH="/path/to/your/reference_image.jpg"

#=========================================================================================
# User Configuration Area
# Configure the post-processing pipeline here.
#=========================================================================================

# 1. Enable automated video creation (true/false)
# If true, the script will generate an MP4 video from the output frames.
ENABLE_VIDEO_CREATION=true

# 2. Path to the audio file for video synchronization.
# If left empty, you must specify VIDEO_DURATION below.
# Example: AUDIO_FILE_PATH="/path/to/your/audio.wav"
AUDIO_FILE_PATH="/path/to/your/audio.wav"

# 3. Manual video duration in seconds.
# This is used only if AUDIO_FILE_PATH is empty.
# Example: VIDEO_DURATION=10.5
VIDEO_DURATION=5

#=========================================================================================
# Script Core Logic
# Do not modify unless you know what you are doing.
#=========================================================================================

# Construct video creation arguments based on the configuration above
VIDEO_ARGS=""
if [ "$ENABLE_VIDEO_CREATION" = true ]; then
    VIDEO_ARGS="--auto-create-video"
    if [ -n "$AUDIO_FILE_PATH" ]; then
        VIDEO_ARGS="$VIDEO_ARGS --audio-for-video $AUDIO_FILE_PATH"
    elif [ -n "$VIDEO_DURATION" ]; then
        VIDEO_ARGS="$VIDEO_ARGS --duration-for-video $VIDEO_DURATION"
    fi
fi

# Get the directory of the current script
script_path=$(realpath $0)
script_dir=$(dirname $script_path)
# Set the checkpoint directory for SwissArmyTransformer
SAT_HOME="/path/to/your/checkpoints" 

# Execute the main AvatarSync pipeline script
MASTER_PORT=${MASTER_PORT} SAT_HOME=${SAT_HOME} python inference_avatarsync_pipeline.py \
        --reference-frame-path ${REFERENCE_IMAGE_PATH} \
        --input-source interactive \
        --output-path ./output_avatarsync \
        --parallel-size 1 \
        --stage-1 \
        --use-guidance-stage1 \
        --guidance-alpha 3.0 \
        --generate-frame-num 5 \
        --tokenizer-type fake \
        --mode inference \
        --distributed-backend nccl \
        --fp16 \
        --model-parallel-size $MPSIZE \
        --temperature $TEMP \
        --coglm-temperature2 0.89 \
        --top_k $TOPK \
        --sandwich-ln \
        --seed 1234 \
        --num-workers 0 \
        --batch-size 1 \
        --max-inference-batch-size 8 \
        --use-face-detection \
        --auto-gfpgan \
        ${VIDEO_ARGS} \
        $@